'use strict';

var _should = require('should');

var _should2 = _interopRequireDefault(_should);

var _optionsValidator = require('./optionsValidator');

var _optionsValidator2 = _interopRequireDefault(_optionsValidator);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

/**
 * @test {OptionsValidator#request}
 */
describe('OptionsValidator', () => {

  let validator;

  before(() => {
    validator = new _optionsValidator2.default();
  });

  /**
   * @test {OptionsValidator#validateNumber}
   */
  describe('validateNumber', () => {

    /**
     * @test {OptionsValidator#validateNumber}
     */
    it('should validate option', () => {
      const value = validator.validateNumber(3, 5, 'opt');
      value.should.eql(3);
    });

    /**
     * @test {OptionsValidator#validateNumber}
     */
    it('should set option to default value if not specified', () => {
      const value = validator.validateNumber(undefined, 5, 'opt');
      value.should.eql(5);
    });

    /**
     * @test {OptionsValidator#validateNumber}
     */
    it('should allow zero value', () => {
      const value = validator.validateNumber(0, 5, 'opt');
      value.should.eql(0);
    });

    /**
     * @test {OptionsValidator#validateNumber}
     */
    it('should throw error if value is not number', () => {
      try {
        validator.validateNumber('test', 5, 'opt');
        _should2.default.not.exist('Should not exist this assertion');
      } catch (err) {
        err.name.should.eql('ValidationError');
        err.message.should.eql('Parameter opt must be a number');
      }
    });

    /**
     * @test {OptionsValidator#validateNumber}
     */
    it('should throw error if value negative', () => {
      try {
        validator.validateNumber(-3, 5, 'opt');
        _should2.default.not.exist('Should not exist this assertion');
      } catch (err) {
        err.name.should.eql('ValidationError');
        err.message.should.eql('Parameter opt cannot be lower than 0');
      }
    });
  });

  describe('validateNonZero', () => {

    /**
     * @test {OptionsValidator#validateNonZero}
     */
    it('should validate option', () => {
      const value = validator.validateNonZero(3, 5, 'opt');
      value.should.eql(3);
    });

    /**
     * @test {OptionsValidator#validateNonZero}
     */
    it('should set option to default value if not specified', () => {
      const value = validator.validateNonZero(undefined, 5, 'opt');
      value.should.eql(5);
    });

    /**
     * @test {OptionsValidator#validateNonZero}
     */
    it('should throw error if value is zero', () => {
      try {
        validator.validateNonZero(0, 5, 'opt');
        _should2.default.not.exist('Should not exist this assertion');
      } catch (err) {
        err.name.should.eql('ValidationError');
        err.message.should.eql('Parameter opt must be bigger than 0');
      }
    });
  });

  /**
   * @test {OptionsValidator#validateBoolean}
   */
  describe('validateBoolean', () => {

    /**
     * @test {OptionsValidator#validateBoolean}
     */
    it('should validate option', () => {
      const value = validator.validateBoolean(true, false, 'opt');
      value.should.eql(true);
    });

    /**
     * @test {OptionsValidator#validateBoolean}
     */
    it('should set option to default value if not specified', () => {
      const value = validator.validateBoolean(undefined, false, 'opt');
      value.should.eql(false);
    });

    /**
     * @test {OptionsValidator#validateBoolean}
     */
    it('should throw error if value is not boolean', () => {
      try {
        validator.validateBoolean('test', 5, 'opt');
        _should2.default.not.exist('Should not exist this assertion');
      } catch (err) {
        err.name.should.eql('ValidationError');
        err.message.should.eql('Parameter opt must be a boolean');
      }
    });
  });
});
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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